<?php 
	/**
	 * Find & assign the post format for this post
	 */
	$format = get_post_format(); 
	if( false === $format ) 
		$format = 'standard'; 
?>
  
<div class="row">

	<div class="col-md-8">
		<?php 
			/**
			 * Get the post format markup for this post
			 */
			
			the_post_thumbnail('full'); 

			if(!( post_password_required() ))
				get_template_part('postformats/format', $format); 
		?>
	</div>
	
	<div class="col-md-4">
		<?php 
			the_title('<h1 class="post-title entry-title">', '</h1>');
		?>
			<div class="navigation"> 
				<?php
					previous_post_link('%link', "<i class='icon-left-open'></i>" );
					echo ' ';
					next_post_link('%link', "<i class='icon-right-open'></i>" ); 
				?>
			</div>
		<div class="divide5"></div>
		<?php 
			if(!( post_password_required() ))
				get_template_part('loop/content','metaportfolio'); 
		?>
	</div>

</div>

<div class="container">
	<div class="galprod">
	<?php the_content(); ?>
	</div>
</div>