<?php
	/*
	Template Name: Key tech
	*/

	/**
	 * page.php
	 * The main post loop in loom
	 * @author TommusRhodus
	 * @package loom
	 * @since 1.0.0
	 */
	get_header();
	the_post();
	
	/**
	 * Get Wrapper Start - Uses get_template_part for simple child themeing.
	 */
	get_template_part('inc/wrapper','start'); 
?>

	<div class="post-content key-tech">
		<div class="container">
			<p class="inspirationback"><i class="icon-left-thin"></i> <a href="http://flintfloor.com/pavimento-hi-tech/">Hi-Tech</a></p>
			<div class="col-sm-4">
				<h2 class="key-tech-title">Key tech.</h2>
				
				<?php
					if ( has_post_thumbnail() ) {
						the_post_thumbnail();
					}
				
					the_title('<h1 class="post-title entry-title">', '</h1>');
					$content = get_the_content('');
					
				?>
					<div class="navigation"> 
						<?php
							previous_post_link('%link', "<i class='icon-left-open'></i>" );
							echo ' ';
							next_post_link('%link', "<i class='icon-right-open'></i>" ); 
							posts_nav_link();
						?>
					</div>
					
					<?php
					$pagelist = get_pages('sort_column=menu_order&sort_order&child_of=135');
					$pages = array();
					foreach ($pagelist as $page) {
					   $pages[] += $page->ID;
					}
					
					$current = array_search(get_the_ID(), $pages);
					$prevID = $pages[$current-1];
					$nextID = $pages[$current+1];
					?>
					
					<div class="navigation">
						<?php if (!empty($prevID)) { ?>
						<a href="<?php echo get_permalink($prevID); ?>"
						  title="<?php echo get_the_title($prevID); ?>"><i class='icon-left-open'></i></a>
						<?php }
						if (!empty($nextID)) { ?>
						<a href="<?php echo get_permalink($nextID); ?>" 
						 title="<?php echo get_the_title($nextID); ?>"><i class='icon-right-open'></i></a>
						<?php } ?>
					</div><!-- .navigation -->
					
					<div class="key-tech-content">
						<?php print $content; ?>
					</div>
			</div>
			<div class="col-sm-8 key-tech-foto">
				<?php if( get_field('foto_key_tech') ): ?>
					<img src="<?php the_field('foto_key_tech'); ?>" width="742" />
				<?php endif; ?>
				
			</div>
		</div>
		
		<?php get_template_part('inc/wrapper','end'); ?>
				
		<?php if ( ICL_LANGUAGE_CODE=='es' ) { ?>
		
		<?php echo do_shortcode('[template id="305"]'); ?>
		
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="58"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
		
		<div class="inspirational">
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="76"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
		</div>
	<?php } elseif ( ICL_LANGUAGE_CODE=='en' ) { ?>
		
		<?php echo do_shortcode('[template id="1549"]'); ?>
		
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="58"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
		
		<div class="inspirational">
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="76"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
	<?php } elseif ( ICL_LANGUAGE_CODE=='fr' ) { ?>
		
		<?php echo do_shortcode('[template id="1619"]'); ?>
		
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="58"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
		
		<div class="inspirational">
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="76"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
	<?php } elseif ( ICL_LANGUAGE_CODE=='de' ) { ?>
		
		<?php echo do_shortcode('[template id="1564"]'); ?>
		
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="58"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
		
		<div class="inspirational">
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="76"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
	<?php } elseif ( ICL_LANGUAGE_CODE=='it' ) { ?>
		
		<?php echo do_shortcode('[template id="1628"]'); ?>
		
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="58"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
		
		<div class="inspirational">
		<?php get_template_part('inc/wrapper','start'); ?>
			<?php echo do_shortcode('[template id="76"]'); ?>
		<?php get_template_part('inc/wrapper','end'); ?>
	<?php } ?>
			
	</div>

<?php
	
	get_footer();