<?php 
	/**
	 * single.php
	 * The single blog post template in loom
	 * @author TommusRhodus
	 * @package loom
	 * @since 1.0.0
	 */
	get_header();
	the_post();
	
	$format = get_post_format(); 
	if( false === $format ) 
		$format = 'standard';
		
	/**
	 * Get Wrapper Start - Uses get_template_part for simple child themeing.
	 */
	get_template_part('inc/wrapper','start'); 
?>
	
	<div class="row">
	
		<div class="col-sm-8 content">
		
			<div class="classic-blog">
			
				<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
					<?php get_template_part('postformats/format', $format); ?>
					
						<div class="post-content image-caption">
						
							<?php 
								the_title('<h2 class="post-title entry-title">', '</h2>'); 
								get_template_part('loop/content','metasingle');
								the_content();
								wp_link_pages();
							?>
							
							<div class="meta tags"><?php the_tags('', ', ', ''); ?></div>
							
							<div class="divide10"></div>
							
							<?php
								if( get_option('blog_social','1') == 1 )
									get_template_part('inc/content','sharing');
							?>
						
						</div><!--post-content-->
					
					</div><!--post-id-->
				
				<hr />
			
			</div><!--classic blog-->
			
			<?php 
				/* if( get_option('blog_author','1') == 1 )
					get_template_part('inc/content','author'); */
			
				if( comments_open() ) 
					comments_template(); 
			?>
		
		</div><!--col-sm-8 content-->
		
		<?php 
			get_sidebar();
		?>
	
	</div><!--row-->

<?php 
	/**
	 * Get Wrapper End - Uses get_template_part for simple child themeing.
	 */
	get_template_part('inc/wrapper','end'); 
	
	get_footer();